// ESTE PROGRAMA MUEVE UN SERVO EN EL PIN 6 A TRAVÉS DE UN POTENCIÓMETRO EN EL PIN A5

#include <Servo.h> // Inclusión de librería, necesario para utilizarla

Servo miServo; // Creación del objeto servo, fuera del setup para que sea una variable global, y se pueda utilizar en todo el código

void setup() {
  Serial.begin(9600); // Inicialización del serial, necesario para ver los datos que imprimamos
  miServo.attach(6); // Configuración del objeto servo, diciéndole dónde está conectado el pin de señal ( pin 6 en este caso)
  pinMode(A5, INPUT); // No sería necesario configurarlo, ya que ya está por defecto. Potenciómetro (pin variable) conectado al A5.
}

void loop() {
  int valor_potenciometro = analogRead(A5); // Asignamos a la variable valor_potenciómetro la lectura del pin A5, que va 0 a 1023
  Serial.print(" Lectura del potenciómetro = "); // Imprimimos indicación de que el valor va a ser del potenciómetro
  Serial.println(valor_potenciometro); // Imprimimos el valor del potenciómetro
  
  int valor_rotacion = map(valor_potenciometro, 0, 1023, 0, 180); // Creamos otra variable con la conversión de lectura potenciómetro (0-1023) a rotación de servo (0-180)
  Serial.print(" Rotación del servo equivalente = "); // Imprimimos indicación de que el valor va a ser de la conversión potenciómetro-servo (grados)
  Serial.println(valor_rotacion); // Imprimimos los grados

  miServo.write(valor_rotacion); // Movemos el servo a esos grados
  delay(50); // Esperamos 50 ms
}
